<?php
/* DrutoPay WHMCS Plugin
 *
 * Copyright (c) 2024 DrutoPay
 * Website: https://drutopay.com/
 * Developer: DrutoPay LTD
 * 
 */

/* 
How to use ?

Go to Module of your file - then go to gateway and upload file in root folder 
then again upload it on Callback file.

 */


if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function drutopaybd_MetaData()
{
    return array(
        'DisplayName' => 'drutopaybd',
        'APIVersion' => '1.0',
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}




function drutopaybd_link($params)
{
    $host_config = $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $host_config = pathinfo($host_config, PATHINFO_FILENAME);

    if (isset($_POST['pay'])) {
        $response = drutopaybd_payment_url($params);
        $response = json_decode($response);
        if ($response->status) {
            return '<form action="' . $response->payment_url . ' " method="GET">
            <input class="btn btn-primary" type="submit" value="' . $params['langpaynow'] . '" />
            </form>';
        }

        return $response->message;
    }


    if ($host_config == "viewinvoice") {
        return '<form action="" method="POST">
        <input class="btn btn-primary" name="pay" type="submit" value="' . $params['langpaynow'] . '" />
        </form>';
    } else {
        $response = drutopaybd_payment_url($params);
        $response = json_decode($response);

        if ($response->status) {
            return '<form action="' . $response->payment_url . ' " method="GET">
            <input class="btn btn-primary" type="submit" value="' . $params['langpaynow'] . '" />
            </form>';
        }

        return $response->message;
    }
}


function drutopaybd_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'drutopaybd',
        ),
        'apiKey' => array(
            'FriendlyName' => 'API Key',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '',
            'Description' => 'Enter Your Api Key',
        ),
        'secretKey' => array(
            'FriendlyName' => 'Secret Key',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '',
            'Description' => 'Enter Your Secret Key',
        ),
        'brandKey' => array(
            'FriendlyName' => 'Brand Key',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '',
            'Description' => 'Enter Your Brand Key',
        ),
        'currency_rate' => array(
            'FriendlyName' => 'Currency Rate',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '120',
            'Description' => 'Enter Dollar Rate',
        )
    );
}

function drutopaybd_payment_url($params)
{
    $cus_name = $params['clientdetails']['firstname'] . " " . $params['clientdetails']['lastname'];
    $cus_email = $params['clientdetails']['email'];

    $apikey = $params['apiKey'];
    $secretkey = $params['secretKey'];
    $brandkey = $params['brandKey'];

    $currency_rate = $params['currency_rate'];

    $invoiceId = $params['invoiceid'];

    if ($params['currency'] == "USD") {
        $amount = $params['amount'] * $currency_rate;
    } else {
        $amount = $params['amount'];
    }
    $hostname = $params['hostName'];


    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')
        $url = "https://";
    else
        $url = "http://";
    // Append the host(domain name, ip) to the URL.   
    $url .= $_SERVER['HTTP_HOST'];

    $systemUrl = $url;

    $success_url = $systemUrl . '/modules/gateways/callback/drutopaybd.php?api=' . $apikey . '&secret=' . $secretkey . '&brand=' . $brandkey . '&invoice=' . $invoiceId;
    $cancel_url = $systemUrl . '/viewinvoice.php?id=' . $invoiceId;


    $data   = array(
        "cus_name"          => $cus_name,
        "cus_email"         => $cus_email,
        "amount"            => $amount,
        "success_url"       => $success_url,
        "cancel_url"        => $cancel_url,
    );

    $header   = array(
        "api"               => $apikey,
        "secret"               => $secretkey,
        "brand"               => $brandkey,
        "url"               => 'https://pay.drutopay.com/api/payment/create',
    );

    $headers = array(
        'Content-Type: application/json',
        'API-KEY: ' . $header['api'],
        'SECRET-KEY: ' . $header['secret'],
        'BRAND-KEY: ' . $header['brand'],
    );
    $url = $header['url'];
    $curl = curl_init();
    $data = json_encode($data);

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_VERBOSE => true
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    return $response;
}